package furny.ga.operators;

import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.GA;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

/**
 * The one point crossover operator cuts the genotype into two segments which
 * are interchanged.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class OnePointCrossoverOp extends ProbabilityOp implements
    ICrossoverOp<FurnLayoutIndividual> {
  // TODO swap-wahrscheinlichkeit pSwap

  /**
   * Creates the operator with a given crossover probability.
   * 
   * @param pCrossOver
   *          Crossover probability.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public OnePointCrossoverOp(final int pCrossOver) {
    super(pCrossOver);
  }

  @Override
  public IndividualList<FurnLayoutIndividual> crossover(
      final FurnLayoutIndividual individual1,
      final FurnLayoutIndividual individual2, final GAContext context) {
    final IndividualList<FurnLayoutIndividual> list = new IndividualList<FurnLayoutIndividual>();
    final FurnLayoutIndividual ind1 = individual1.clone();
    final FurnLayoutIndividual ind2 = individual2.clone();

    if (doOperate()) {
      FurnEntryList smaller;
      FurnEntryList bigger;
      if (ind1.getFurnitures().size() < ind2.getFurnitures().size()) {
        smaller = ind1.getFurnitures();
        bigger = ind2.getFurnitures();
      } else {
        smaller = ind2.getFurnitures();
        bigger = ind1.getFurnitures();
      }

      final int iCut = getRandom().nextInt(smaller.size());

      for (int i = 0; i <= iCut; i++) {
        smaller.set(i, bigger.set(i, smaller.get(i)));
      }
    }

    list.add(ind1);
    list.add(ind2);

    return list;
  }

  /**
   * Main method for testing.
   * 
   * @param args
   *          No arguments required.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void main(final String[] args) {
    final GAContext context = new GAContext();
    context.put(GA.KEY_VALIDATION_SPACE, new PseudoSpace(10f, 10f));

    final FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
    ind1.initRandomly();

    final FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
    ind2.initRandomly();

    final OnePointCrossoverOp crossover = new OnePointCrossoverOp(100);

    System.out.println("\n PARENT 1\n");
    FurnLayoutIOUtil.printSimpleGenotype(ind1.getSimpleGenotype());

    System.out.println("\n PARENT 2\n");
    FurnLayoutIOUtil.printSimpleGenotype(ind2.getSimpleGenotype());

    final IndividualList<FurnLayoutIndividual> list = crossover.crossover(ind1,
        ind2, context);

    for (int i = 0; i < list.size(); i++) {
      final FurnLayoutIndividual newInd = list.get(i);

      System.out.println("\n CHILD " + (i + 1) + "\n");
      FurnLayoutIOUtil.printSimpleGenotype(newInd.getSimpleGenotype());
    }

  }
}
